/* Import de la classe initialisationBDD */
import { initialisationBDD } from '@lib/mysql';

/*
	Fonction get (récupération des données depuis la table sports)
	NB : Voir documentation officielle à l'adresse :
	     https://sapper.svelte.dev/docs#Server_routes
*/
export function get(req, res, next) {
	
	/*
		Instanciation de db
		NB : La méthode initialisationBDD() est présente
		     dans le script src/node_modules/@lib/mysql.js 
	*/
	const { db } = initialisationBDD();

	/* Exécution de la requête SQL */
	db.query(`SELECT * FROM sports;`, (err, results, fields) => {
		/* Cas d'erreur */
		if (err) throw err;
		// Contenu Json
		res.writeHead(200, {
			'Content-Type': 'application/json'
		});
		res.end(JSON.stringify(results));
	});

}